#
#  $Id: Gene3d.pm,v 1.2 2007/10/16 22:52:11 whuang Exp $
#  fastHmm/fastBlast Alignment Tools
#  http://microbesonline.org/fasthmm (fasthmm@microbesonline.org)
#
#  Gene3d-related parsing functions
#
#  Copyright (C) 2007 The Regents of the University of California
#  All rights reserved.
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#  USA.
#
#  Disclaimer
#
#  NEITHER THE UNITED STATES NOR THE UNITED STATES DEPARTMENT OF ENERGY,
#  NOR ANY OF THEIR EMPLOYEES, MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
#  OR ASSUMES ANY LEGAL LIABILITY OR RESPONSIBILITY FOR THE ACCURACY,
#  COMPLETENESS, OR USEFULNESS OF ANY INFORMATION, APPARATUS, PRODUCT,
#  OR PROCESS DISCLOSED, OR REPRESENTS THAT ITS USE WOULD NOT INFRINGE
#  PRIVATELY OWNED RIGHTS.
#

package Gene3d;
require Exporter;

use strict;

use vars '$VERSION';
$VERSION = 0.01;

our @ISA = qw(Exporter);
our @EXPORT = qw();

sub loadAccToFamMap
{
	my $dbDir = shift;

	my $mapFile = $dbDir . "/gene3d/gene3d.tab";
	local *IN;
	my %map = ();

	if ( -e $mapFile )
	{
		open(IN, "<$mapFile");
		while(<IN>)
		{
			chomp;
			my ( $acc, $fam ) = split(/\t/, $_, 2);
			$map{$acc} = $fam;
		}
		close(IN);
	}

	return \%map;
}

1;
