#
#  $Id: Pfam.pm,v 1.2 2007/10/16 22:52:11 whuang Exp $
#  fastHmm/fastBlast Alignment Tools
#  http://microbesonline.org/fasthmm (fasthmm@microbesonline.org)
#
#  Pfam-related parsing functions
#
#  Copyright (C) 2007 The Regents of the University of California
#  All rights reserved.
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#  USA.
#
#  Disclaimer
#
#  NEITHER THE UNITED STATES NOR THE UNITED STATES DEPARTMENT OF ENERGY,
#  NOR ANY OF THEIR EMPLOYEES, MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
#  OR ASSUMES ANY LEGAL LIABILITY OR RESPONSIBILITY FOR THE ACCURACY,
#  COMPLETENESS, OR USEFULNESS OF ANY INFORMATION, APPARATUS, PRODUCT,
#  OR PROCESS DISCLOSED, OR REPRESENTS THAT ITS USE WOULD NOT INFRINGE
#  PRIVATELY OWNED RIGHTS.
#

package Pfam;
require Exporter;

use strict;

use vars '$VERSION';
$VERSION = 0.01;

our @ISA = qw(Exporter);
our @EXPORT = qw();

sub loadAccToClanMap
{
	my $dbDir = shift;
	my $withVer = shift;

	$withVer = 1
		if ( !defined($withVer) );

	my $clanMapFile = $dbDir . "/pfam/Pfam-C.map";
	local *IN;
	my %map = ();

	if ( -e $clanMapFile )
	{
		open(IN, "<$clanMapFile");
		while(<IN>)
		{
			chomp;
			my ( $clan, $acc ) = split(/\t/, $_, 2);
			( $acc ) = $acc =~ /^(PF\w+)/
				if ( !$withVer );
			$map{$acc} = $clan;
		}
		close(IN);
	}

	return \%map;
}

sub loadAMMap
{
	my $dbDir = shift;
	my $withVer = shift;

	$withVer = 1
		if ( !defined($withVer) );

	my $amMapFile = $dbDir . "/pfam/pfam.am";
	local *IN;
	my %map = ();

	if ( -e $amMapFile )
	{
		open(IN, "<$amMapFile");
		while(<IN>)
		{
			chomp;
			my ( $acc, $am ) = split(/\t/, $_, 2 );
			( $acc ) = $acc =~ /^(PF\w+)/
				if ( !$withVer );
			$map{$acc} = $am;
		}
		close(IN);
	}

	return \%map;
}

1;
