#
#  $Id: Util.pm,v 1.4 2007/10/16 22:52:11 whuang Exp $
#  fastHmm/fastBlast Alignment Tools
#  http://microbesonline.org/fasthmm (fasthmm@microbesonline.org)
#
#  Utilities module
#
#  Copyright (C) 2007 The Regents of the University of California
#  All rights reserved.
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#  USA.
#
#  Disclaimer
#
#  NEITHER THE UNITED STATES NOR THE UNITED STATES DEPARTMENT OF ENERGY,
#  NOR ANY OF THEIR EMPLOYEES, MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
#  OR ASSUMES ANY LEGAL LIABILITY OR RESPONSIBILITY FOR THE ACCURACY,
#  COMPLETENESS, OR USEFULNESS OF ANY INFORMATION, APPARATUS, PRODUCT,
#  OR PROCESS DISCLOSED, OR REPRESENTS THAT ITS USE WOULD NOT INFRINGE
#  PRIVATELY OWNED RIGHTS.
#

package Util;
require Exporter;

use strict;

use vars '$VERSION';
$VERSION = 0.01;

our @ISA = qw(Exporter);
our @EXPORT = qw();

sub configParams
{
	my $conf = shift;
	my $prefix = shift;
	my @params = ();

	foreach my $key ( sort( keys( %{$conf} ) ) )
	{
		if ( $key =~ /^${prefix}_(\w+)/ )
		{
			my $arg = $1;
			if ( $arg ne 'FLAGS' )
			{
				push( @params, "-${arg} " . $conf->{$key} );
			} else {
				push( @params, $conf->{$key} );
			}
		}
	}

	return join(" ", @params);
}

sub firstDefined
{
	while ( my $val = shift )
	{
		return $val
			if ( defined($val) );
	}
	return undef;
}

sub commify
{
	my $number = shift;
	my $neg = ( $number < 0 ) ? -1 : 1;
	my $tmp = reverse( $number * $neg );

	return $number
		if ( length($tmp) < 4 );

	$tmp =~ s/(.{3})\B/$1,/g;
	$tmp = reverse( $tmp );
	$tmp = '-' . $tmp
		if ( $neg < 0 );

	return $tmp;
}

sub formatBp
{
	my $numBp = shift;

	if ( $numBp < 1000 )
	{
		return $numBp;
	} elsif ( $numBp < 1000000 )
	{
		return sprintf("%.2f Kb", ($numBp*1.0/1000));
	} elsif ( $numBp < 1000000000 )
	{
		return sprintf("%.2f Mb", ($numBp*1.0/1000000));
	} else
	{
		return sprintf("%.2f Gb", ($numBp*1.0/1000000000));
	}
}

1;
